* ==============================================================================
* Date	: 08 - 11 - 2019
* Paper	: The heterogeneous effects of standards on agrifood trade 
* Author: Dela-Dem Doe Fiankor, Oliver Ken-Haase, Bernhard Brümmer
* Outlet: Journal of Agricultural Economics (R&R)
* E-mail: dfianko@agr.uni-goettingen.de
*
* The user must define one global macro in order to run the analysis:
* (1) "translog_gvty" points to the project folder
* ==============================================================================

*global translog_gvty "/Users/ddfiankor/ownCloud/Projects/Ongoing/Translog gravity"
global translog_gvty "C:\Users\fiankor1\Desktop\Translog gravity"
	
assert !missing("$translog_gvty") // Confirm that the globals for the project root directory has been defined
set more off

cap mkdir "$translog_gvty\processed"
cap mkdir "$translog_gvty\results"
cap mkdir "$translog_gvty\results\figures"
cap mkdir "$translog_gvty\results\tables"

* Initialize log and record system parameters
clear 
cap log close
local datetime : di %tcCCYY.NN.DD!_HH.MM.SS `=clock("$S_DATE $S_TIME", "DMYhms")'
local logfile "$translog_gvty/scripts/log_`datetime'.txt"
log using "logfile", text replace

di "Begin date and time: $S_DATE $S_TIME"
di "Stata version: `c(stata_version)'"
di "Updated as of: `c(born_date)'"
di "Variant:       `=cond( c(MP),"MP",cond(c(SE),"SE",c(flavor)) )'"
di "Processors:    `c(processors)'"
di "OS:            `c(os)' `c(osdtl)'"
di "Machine type:  `c(machine_type)'"	

* Run project analysis
do "$translog_gvty/scripts/1_data_cleaning.do"
do "$translog_gvty/scripts/2_descriptives.do"
do "$translog_gvty/scripts/3_regressions.do"

* End log
di "End date and time: $S_DATE $S_TIME"
log close

* EOF
